class Square:

  def __init__(self, values):
    if not isinstance(values, type([])):
      raise TypeError("Parameter is not a list")
    if len(values) != 16:
      raise TypeError("List has not 16 values")
    for i in range(16):
      try:
        values[i] = int(values[i])
      except:
        raise TypeError("Value at position %i cannot be converted to int" % i)
    self.__data = values

  def __str__(self):
    return "Square:\n"\
      "%2i %2i %2i %2i\n"\
      "%2i %2i %2i %2i\n"\
      "%2i %2i %2i %2i\n"\
      "%2i %2i %2i %2i" % tuple(self.__data)

  def __getitem__(self, i):
    return self.__data[i]

  def __cmp__(self, other):
    if not isinstance(other, Square):
      raise TypeError("Not of type Square")
    for i in range(16):
      if self[i] < other[i]:
        return -1
      if self[i] > other[i]:
        return 1
    return 0
  
  def __hash__(self):
    return hash(tuple(self.__data))

  def is_valid(self):
    for i in range(4):
      # Zeilen
      row = i * 4
      if self[row] + self[row + 1] + self[row + 2] + self[row + 3] != 30:
        return False
      # Spalten
      col = i
      if self[col] + self[col + 4] + self[col + 8] + self[col + 12] != 30:
        return False
    # Diagonalen
    if self[ 0] + self[ 5] + self[10] + self[15] != 30:
      return False
    if self[ 3] + self[ 6] + self[ 9] + self[12] != 30:
      return False
    return True

ALL = []
for line in open("./square/all_squares.txt").readlines():
  ALL.append(Square(line.split(" ")))
e = ALL[0]
