from Square import Square
from Square import ALL

class Operator:

  def __call__(self, x):
    if not isinstance(x, Square):
      raise TypeError("Not of type Square")
    return self.funktion(x)

  def __eq__(self, other):
    if not isinstance(other, Operator):
      raise TypeError("Not of type Operator")
    for i in ALL:
      if self(i) != other(i):
        return False
    return True

  def __ne__(self, other):
    return not (self == other)

  def __pow__(self, other):
    if not isinstance(other, Operator):
      raise TypeError("Not of type Operator")
    return CombOperator(self, other)

  def getFull(self):
    ret = {}
    for i in ALL:
      ret[i] = self(i)
    return FullOperator(ret)

class ArrowOperator(Operator):

  def __init__(self, values):
    if not isinstance(values, type([])):
      raise TypeError("Parameter is not a list")
    if len(values) != 16:                       
      raise TypeError("List has not 16 values")
    self.data = values

  def __str__(self):
    return "ArrowOperator:\n" \
      "%2i %2i %2i %2i\n" \
      "%2i %2i %2i %2i\n" \
      "%2i %2i %2i %2i\n" \
      "%2i %2i %2i %2i\n" % tuple(self.data)

  def __eq__(self, other):
    if not isinstance(other, ArrowOperator):
      return Operator.__eq__(self, other)
    for i in range(16):
      if self.data[i] != other.data[i]:
        return False
    return True

  def __pow__(self, other):
    if not isinstance(other, ArrowOperator):
      return Operator.__pow__(self, other)
    ret = []
    for i in range(16):
      ret.append(other.data[self.data[i]])
    return ArrowOperator(ret)

  def funktion(self, x):
    ret = []
    for i in range(16):
      ret.append(x[self.data[i]])
    return Square(ret)
  
class FktOperator(Operator):

  def __init__(self, fkt, name):
    self.funktion = fkt
    self.name = name
  
  def __str__(self):
    return "Function Operator: %s\n" % (self.name)

class CombOperator(Operator):

  def __init__(self, x, y):
    if not isinstance(x, Operator):
      raise TypeError("First parameter is not of type Operator")
    self.first = x
    if not isinstance(y, Operator):
      raise TypeError("Second parameter is not of type Operator")
    self.second = y
  
  def funktion(self, x):
    return self.first(self.second(x))

  def __str__(self):
    return "CombOperator:\n" \
      "First: %s\n" \
      "Second: %s\n" % (self.first, self.second)

class FullOperator(Operator):

  def __init__(self, values):
    if not isinstance(values, type({})):
      raise TypeError("Parameter is not a dictionary")
    if len(values) != 7040:
      raise TypeError("List has not 7040 values")
    self.data = values
  
  def funktion(self, x):
    return self.data[x]

E = ArrowOperator([0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15])
R = ArrowOperator([12, 8, 4, 0, 13, 9, 5, 1, 14, 10, 6, 2, 15, 11, 7, 3])
L = R ** R ** R
V = ArrowOperator([3, 2, 1, 0, 7, 6, 5, 4, 11, 10, 9, 8, 15, 14, 13, 12])
H = L ** V ** R
X = ArrowOperator([5, 4, 7, 6, 1, 0, 3, 2, 13, 12, 15, 14, 9, 8, 11, 10])

def swap(x):
  if not isinstance(x, Square):
    raise TypeError("Not of type Square")
  ret = []
  for i in range(16):
    ret.append(15 - x[i])
  return Square(ret)
S = FktOperator(swap, "Swap")
 