# -*- coding: iso-8859-15 -*-

from template import PSP
from conf.config import Config
from conf.taglib import Taglib
import cgi
import traceback

import os

class Controller:
   """
   Basisklasse fuer eine Controller
   Die Klasse wird vom Framework automatisch
   generiert und initialisiert.

   """
   html                 = ''
   addEntry             = None
   setEntryDisplay      = None
   setEntryParam        = None
   path                 = ''
   db                   = None
   main                 = None
   cgiparam             = None
   form                 = None

   def render(self,text=''):
      """
      Einfuegen String in Buffer.

      Beispiel: self.render("Hallo Welt")

      @param   text        Auszugebender Text

      """
      self.html = self.html + text


   def view(self,filename,param=None,importcgi=False):
      """
      Aufrufen Viewer
      
      @param   filename          Filenamen des Viewer
      @param   param             Binding Variable fuer den 
                                 Viewer, welch dort verwenden werden koennen.
      @param   importcgi         Felder eine Form werden automatisch
                                 aus dem CGI befuellt
      """
      viewerfile = Config.mvcpath+self.path+'/'+filename
      viewerfile = viewerfile.replace('\\','/')
      fViewer = open(viewerfile,'r')
      text = fViewer.read()

      try:
         psp = PSP(template=text,filename=filename,cgiparam=self.cgiparam)
      except Exception,e:
         self.html = "Fehler im Template:<br />%(filename)s<br />%(error)s" % {'filename':filename,'error':e}
         return True

      # Importiert alle CGI Parameter in Param
      if importcgi:
         self.form=cgi.FieldStorage()
         for fld in self.form:
            param[fld]=self.form[fld].value
      value = ''

      value = psp.render(param)

      self.html = self.html + value
