# -*- coding: iso-8859-15 -*-


class AuthenBase(object):
   """
   Basisklasse fuer Authentifizierung

    Die Autentifizierung basiert auf einer
    Sessionvariable namens user. Ist diese
    gesetzt gilt der Benutzer als angemeldet
   """

   user = None
   session = None
   rights = None
   userlist = {}
   db = None

   def __init__(self,session=None,db=None):
      """
      Konstruktor
      @param   session        Sessionobjekt
      """
      if db != None: self.db = db
         
      if session == None:
         raise(Exception('Das Objekt muss mit einem Sessionobjekt befuellt werden'))
      self.session = session
      self.init()

   def getUser(self):
      """Liefert den aktuellen User"""
      return self.user

   def init(self):
      """ Initialisierung"""
      self.user      = self.session.getAttribute('user')      
      theUser = self.getUserinfo(user=self.user)
      self.rights    = theUser.get('rights')


   def isAuthenticated(self):
      """Liefert wahr, wenn benutzer vorhanden ist"""
      if self.user != None:
         return True
      else:
         return False

   def getRights(self):
      """ABSTRAKT: 
      liefert eine Liste von Rechten, wenn Benutzer eingelogt
      """
      if self.isAuthenticated():
         return self.rights
      else:
         return []

   def hasRight(self,right=None):
      """
      Liefert True, wenn uebergebenens Recht in der Rechteliste vorhanden ist
      @param   right    Recht
      
      @return  [True|False] 
      """
      if self.isAuthenticated():
         found = False
         # Gibt es keine Rechte
         # wird auf jeden Fall Wahr zurueckgeliefert
         if self.rights == None: return False
         for theRight in self.rights:
            if right == theRight: found = True
         return found
      else:
         return False

   def getUserinfo(self,user=''):
      """
      Liefert die Userinformatioenn oder eine leeres Dictionary,wenn nicht gefunden.
      @param   user  Benutzername
      """
   
      found = None
      for usr in self.userlist:
         if usr['user'] == user:
            found = usr

      if found == None:
         return {}
      else:
         return found


   def getPassword(self):
      """Liefert Passwort des aktuellen Benutzers oder None wenn nicht gefunden"""
      user = self.getUserinfo()
      if user != {}:
         return None
      else:
         return user['password']

   def authen(self):
      """Setzt die Rechte des Users, wenn eingeloggt"""
      if self.user != None:
         user = getUserinfo()
         self.rights = user['rights']
