# -*- coding: iso-8859-15 -*-
"""
   Routie zum Maskenhandling.

   Es werden zwei Layouts angeboten
   List/Edit:
      Es wird eine Liste angeboten, welche eine Editierbutton enthaelt.
      Wird dieser betaetigt, so wird eine Editiermaske mit dem gewaehlten
      Datensatz angezeigt.
      Dieser kann Veraendert oder geloescht werden.
   """
from utility      import Utility
from pagination   import Pagination

import copy

class Viewhandler() :

   controller        = None
   domain            = None
   listparam         = {}

   listView          = 'list.tpl'
   editView          = 'edit.tpl'
   gridView          = 'grid.tpl'

   LOADFROMCGI       = 'cgi'
   LOADFROMDOMAIN    = 'domain'
   LOADEMTPY         = None

   SAVE              = 'save'
   EDIT              = 'edit'
   DELETE            = 'delete'
   NEW_EDIT          = 'new-edit'
   LIST              = 'list'

   GRID_LAYOUT       = 'grid'
   LISTEDIT_LAYOUT   = 'listedit'
   LIST_LAYOUT       = 'list'

   textNew           = 'neu'

   layout            = GRID_LAYOUT

   invalidDomain     = None
   gridlist          = None
   where             = None
   orderby           = None
   filter            = None

   limit             = None

   pagination        = None

   # ### nextDomain Mode
   #
   NONE               = 0b00000000
   NEVERNEWEDIT       = 0b00000001
   NEWEDIT            = 0b00000010
   action             = None

   def __init__(self,
                controller=None,
                db=None,
                domain=None,
                listparam=None,
                layout=None,
                gridlist=None,
                where=None,
                orderby=None,
                limit=None,
                filter=None,
                pagination=None,
                curpage=None
                ):
      if controller == None: raise Exception('Bei Viewhandler fehlt Parameter "controller"')

      self.controller   = controller
      self.domain       = domain
      if listparam != None:
         self.listparam=listparam
      self.listparam['path'] = self.controller.cgiparam(name='path',nvl='')

      if layout != None: self.layout = layout
      self.gridlist = gridlist
      self.where=where
      self.orderby=orderby
      self.limit = limit
      self.filter = filter

      if pagination != None:
         if isinstance(pagination,int):
            self.paginationFactory(pagination)
         elif isinstance(pagination,dict):
            self.paginationFactory(pagination['curpage'])
         else:
            raise Exception('viewhandler: die Option pagination muss ein Dictionary sein.')
      self.action = self.controller.cgiparam(name='action',nvl='')


   def paginationFactory (self,curpage):
      """
      Erzeugen eines Paginations Objekts

      @param   curpage        aktuelle Seite
      """
      countrec = self.countRecords()
      pagination = Pagination(records=countrec,curpage=curpage)

      # in Viewhandler Limit eintragen = ([von Datensatz],[max. Anzahl der auszugebenden Datensaetze])
      self.limit = (curpage * pagination.pagesize,pagination.pagesize)

      # Erzeugen und Uebergeben einer Paginationsliste
      self.listparam['pagination'] = pagination

      #
      # ### Ende Pagination



   def getCurrentDomain(self,domain=None):
      """ Gibt die aktuelle domain zurueck.

          @param  domain         Domainobjekt

          Ist domain deklariert, wird diese geliefert.
          Ist domain None, wird versucht die Klassendomain
          zu liefer. Ist diese auch nicht deklariert wird eine
          Ausnahme geworfen
          """
      if domain != None:
         return domain

      if self.domain == None:
         raise Exception('Es wurde weder der Parameter domain noch self.doamin delklariert')

      return self.domain

   def loadDomain(self,domain=None,key=None):
      """ Laedt die Domain aus der Datenbank

          @param  domain      Domain Objekt
                              ist dieser None wird das aktuelle Domainobjekt
                              des Objekts verwendet.

          @param  key         Wert ueber welchen aus der
                              Datenbak gelesen werde soll.
                              Ist dieser nicht deklariert,
                              wird der Wert aus dem CGI ermittelt.

          """


      curDomain = self.getCurrentDomain(domain)

      if key == None:
         pk = curDomain.getPK()
         key = self.controller.cgiparam(name=pk,nvl='')

      curDomain.get(key)


   def showEditMask(self,loadfrom='cgi',domain=None):
      """ Anzeigen einer Editiermaske.

          @param  loadfrom       gibt an, von wo die
                                 Felder befuellt werden sollen
                                 'cgi'    Daten aus dem CGI
                                 'domain' Daten aus der Domain
                                 None     Leere Maske wird angezeigt.

          Als Viewerfile wird edit.tpl angenommen (wenn nicht anders in der
          Klassenvariable deklariert.
          """

      # Automatischer Zurueck-Button  ausshalten
      # und auf List Anzeige anpassen.
      returnText = self.controller.menu.returnText
      self.controller.menu.returnText = None

      self.controller.addEntry(
         path='@current',
         text=returnText,
         addparam=['action=list']
         )

      utility = Utility()
      curDomain = self.getCurrentDomain(domain)
      
      if loadfrom == self.LOADFROMCGI:
         curDomain.fromCgi(self.controller.cgiparam,typecheckStrict=False)

      elif loadfrom == self.LOADFROMDOMAIN:
         self.loadDomain(curDomain)
         
      elif loadfrom == self.LOADEMTPY:
         curDomain.clear()
      else:
         raise Exception("Eine ungueltige Option von loadfrom '{0} stellt sich vor.".format(loadfrom))
      
      fields = utility.fieldsObjectFactory(curDomain)
                  
      self.controller.view(self.editView,{
         'fields':fields,
         'path':self.controller.cgiparam(name='path',nvl=''),
         'controller':self.controller
         })


   def showList(self,listparam=None,action=None):
      """
      Behandelt bei List/Edit layout die Liste

      @param   listparam         Ein Dictionary, welches die
                                 Parameter fuer List-Viewer enhaelt.
      """

      curListparam = self.listparam
      if listparam != None:
         curListparam = listparam

      self.controller.view (self.listView,curListparam)

   def save(self,key=None, domain=None,action=None):
      # Wenn eine Fehler aufgetreten ist
      # Daten aus dem CGI einlesen
      self.invalidDomain = None

      curDomain = None

      # Wurde domain uebergeben
      # diese verwenden
      if domain == None:
         curDomain = self.domain

      # Versuche die Domain aus Klasse zu bekommen
      if curDomain == None:
         curDomain = self.domain

      if key == None:
         key = curDomain.getPK()

      if action == None:
         action= self.controller.cgiparam(name='action', nvl=self.SAVE)

      isOk = curDomain.writedb(
         cgiparam=self.controller.cgiparam,
         flash=self.controller.flash,
         action=action,
         id=key
         )

      # Fehlerfall behandeln
      # Wenn nicht OK wird die aktuelle Domain gestellt
      # sonst enthaelt das Attribut None
      #
      if not isOk:
         self.controller.flash('<br />'.join(curDomain.errors))
         self.invalidDomain = copy.copy(curDomain)
      else:
         self.invalidDomain = None

      return isOk

   def nextDomain(self,domain=None,where=None,orderby=None,onRead=None,filter=None,mode=NONE):
      """
      Liefert fuer jeden gefunden Datensatz ein Tupple zurueck.

      1 die Domain
      2 ein Boolean das angibt, ob eine Daten oder Eingabemaske
        erzeugt werden soll.

      @param      domain         Domain Objekt
      @param      where          SQL Where Klausel
      @param      orderby        SQL Order By Klausel
      @param      onRead         Handler wird nach jedem Aufruf
                                 einer Domain aufgerufen. Der Routine
                                 wird mit der Domain und dem Kennzeichen
                                 isEditMask befuellt  und liefert
                                 die Domain zurueck.
      @param      filter         Filter Optione fuer eachDomain
      @param      nevernewedit   [True|False] Wenn True wird keine
                                 leere Editiermaske am Ende der Liste angezeigt.
      """
      newedit = True
      isDelete = False
      pk = domain.getPK()

      for curDomain in domain.eachDomain(where=where,orderby=orderby,limit=self.limit,filter=self.filter):

         isEditMask = self.isEditMask(pk,curDomain.getValue(pk))

         # Behandlung wenn Fehler beim schreiben in die Datenbank
         # aufgetreten ist.
         if self.invalidDomain != None and self.invalidDomain.getValue(pk) == curDomain.getValue(pk):

            if curDomain.mode == curDomain.DELETE:
               isDelete = True
               isEditMask = False
            else:
               curDomain = self.invalidDomain
               isEditMask = True

         if isEditMask: newedit = False
         if curDomain.mode == curDomain.DELETE:
            newedit = True

         if onRead != None:
            curDomain = onRead(curDomain,isEditMask)

         yield (curDomain,isEditMask)

      if mode != self.NEVERNEWEDIT and newedit:
         # HINT: domain sicherheitshalber leeren.
         if not isDelete and self.invalidDomain != None:
            domain = self.invalidDomain
         else:
            domain.clear()

         if onRead != None:
            curDomain = onRead(curDomain,True)
         yield (domain,True)

   def datarow(self,row=[],nvl='',params=[]):
      """
      Liefert eine Liste von Eintraegen.
      Ist eine Element der Liste leer, so wird
      der Wert aus nvl ausgegeben.

      @param 1          Nono Wert
      @param 2..        offene Liste von Werten
      """
      for value in params:
         if value == None: value = nvl
         row.append(value)



   def gridrow(self,editmask=None,listrow=None,list=None,taglib=None,addhidden=[]):
      """ Erzeugen einer Grid Row

          @param  editmask       Routine welche die Editiermaske beschreibt
          @param  listrow        Routine welche eine Liste mit Datenzeileneintragen erzeugt
          @param  list           Routine welche durch die Datenzeilen itteriert.
                                 Diese liefert zwei Werte
                                   1) Eine Domain mit den Dateninhalten
                                   2) ein Flag welches angeibt ob die Domain als
                                      Datenliste oder als Editiermaske angezeigt werden soll
          @param  taglib         das aktuelle Taglib Objekt

          @return Ein HTML Fragment, welches die gerenderte Datentabelle liefert.

          """

      rows = []
      path = self.controller.path
      def viewHelper():
         for (curDomain,isEditMask) in self.nextDomain(domain=self.domain,where=self.where,orderby=self.orderby):
            yield (curDomain,isEditMask)

      for (domain,isEditMask) in list():
         # Wenn Editiermaske, diese Ausgeben
         if isEditMask:
            newedit=False  # Keine Neueingabemaske
            rows.append('<!-- EDITIERMASKE -->')
            rows.append(taglib.form(name='grid-edit'))
            rows.append(taglib.hidden(name='path',value=path))
            for hidden in addhidden:
               rows.append(taglib.hidden(name=hidden[0],value=hidden[1]))
            rows.append('\n'.join(editmask(domain)))
            rows.append(taglib.endform())
            rows.append('<!-- ENDE EDITIERMASKE -->')
         else:
            rows.append(taglib.tablerow(listrow(domain)))

      return '\n'.join(rows)

   def countRecords (self):
      """
      Liefert die Anzahl der Datensaetze,
      welche basierend auf filter und where gefunden werden.
      """
      retval = self.domain.count(self.where,self.filter)
      return retval




   def handleListEdit(self):
      """ Shot and forget Funktion fuer Behandlung
          eines List-Edit Layouts
          """
      #action = self.controller.cgiparam(name='action',nvl='')
      action = self.action

      # Neu Anzeigen?
      if action in [self.LIST,self.SAVE,self.DELETE,'']:
         self.controller.addEntry(
            path='@current',
            text=self.textNew,
            addparam=['action='+self.NEW_EDIT]
            )

      # Liste Anzeigen
      if action in [self.LIST,'']:
         self.showList()

      # Eingaben aus Maske speichern
      elif action in [self.SAVE,self.DELETE]:
         isOk = self.save()
         if isOk:
            self.showList()
         else:
            self.showEditMask(loadfrom='cgi')

      # Editiermaske anzeigen
      elif action == self.EDIT:
         self.showEditMask(loadfrom='domain')

      elif action == self.NEW_EDIT:
         self.showEditMask(loadfrom=None)

      elif action == self.DELETE:
         self.showEditMask(loadfrom=None)

      # Sonst Fehler
      else:
         raise ValueError("Eine bislang unbekannte Action '{0}' stellt sich vor".format(action))

   def isEditMask(self,idfieldname,domainvalue):
      """ Prueft ob ein Eingabemaske angezeigt werden soll
          @param  idfieldname       Name des ID Fields
          """
      action = self.controller.cgiparam('action')
      idfieldvalue = self.controller.cgiparam(idfieldname)
      retval = action not in ['save','delete'] and str(idfieldvalue) == str(domainvalue)
      return retval

   def handleGrid(self):
      """
      Shot and forget Funktionen fuer Behandlung
      eines Grid Layouts.
      """
      if self.action != None:         
         action = self.controller.cgiparam('action')
      else: action = self.action

      
      if action in ['save','delete']:
         isOk = self.save(action=action)
         if not isOk:
            self.listparam['isOk']=False

      if 'controller' not in self.listparam.keys():
         self.listparam['controller'] = self.controller
      
      if self.gridlist == None:

         def viewHelper():
            nxtRecord = self.nextDomain(domain=self.domain,where=self.where,orderby=self.orderby)
            for (curDomain,isEditMask) in nxtRecord:
               yield (curDomain,isEditMask)

         self.listparam['list'] = viewHelper

         self.controller.view(self.gridView,self.listparam)
      else:         
         if 'list' not in self.listparam.keys():
            if self.gridlist != None:
               self.listparam['list'] = self.gridlist
            else:
               raise Exception('Viewhandler::handleGrind: Es wurde kein list Methode deklariert')
         
         self.controller.view (self.gridView,self.listparam)

   def handleList (self):
      """
      Kobination aus GRID Anzeige der Datenzeilen mit Editmasek
      """
      action = self.controller.cgiparam(name='action')

      self.listparam['controller'] = self.controller
      def viewHelper():
         yield (self.domain,True)

      if action in ['save','delete']:
         isOk = self.save(action=action)
         if not isOk:
            self.listparam['isOk']=False
            self.listparam['list'] = viewHelper
            self.controller.view(self.gridView,self.listparam)
            return

      elif action == self.NEW_EDIT:
         self.domain.clear()
         self.loadDomain(self.domain)
         self.listparam['list'] = viewHelper
         self.controller.view(self.gridView,self.listparam)
         return

      elif action == self.EDIT:
         self.loadDomain(self.domain)
         self.listparam['list'] = viewHelper
         self.controller.view(self.gridView,self.listparam)
         return

      if self.gridlist == None:
         # Neu Anzeigen?
         if action in [self.LIST,self.SAVE,self.DELETE,'']:
            self.controller.addEntry(
               path='@current',
               text=self.textNew,
               addparam=['action='+self.NEW_EDIT]
               )
         def viewHelper():
            # nevernewedit schalte die zusaetzliche Eingabezeile aus
            #
            for (curDomain,False) in self.nextDomain(domain=self.domain,where=self.where,orderby=self.orderby,mode=Viewhandler.NEVERNEWEDIT):
               yield (curDomain,False)

         self.listparam['list'] = viewHelper
         self.controller.view(self.gridView,self.listparam)

   def run(self,layout=None):
      """ Allgemeiner Aufruf des Viewhandlers.
          In der Opton layout wird festgelegt ob
          Grid oder List/Edit angewendet werden soll.
          """
      if layout == None:
         layout = self.layout

      if self.controller == None:
         raise Exception('Viewhandler.:run kann keine Referenz auf controller finden.')
      
      if layout == self.GRID_LAYOUT:
         self.handleGrid()
      elif layout == self.LISTEDIT_LAYOUT:
         self.handleListEdit()
      elif layout == self.LIST_LAYOUT:
         self.handleList()
      else:
         raise Exception('Es wurde weder LIST/EDIT nocht GRIND Layout deklariert' )
