# -*- coding: iso-8859-15 -*-
import sys
import os

from conf.config import Config

"""
 Abstrakte Klasse fuer die Menudarstellung
 Sie wird normalerweise von der Klasse Menu im WEB-INF/conf/menu
 importiert.
"""

class MenuBase:

   # ### GLOBALS
   #

   authen = None
   config = Config()

   # Container fuer Menuedarstellung
   tplMenuContainer     = config.tplMenuContainer
   tplMenuEntry         = config.tplMenuEntry
   tplMenuBullet        = config.tplMenuBullet

   # Container fuer Backlink Darstellung
   tplBacklinkContainer = config.tplBacklinkContainer
   tplBacklinkEntry     = config.tplBacklinkEntry
   tplBacklinkSep       = config.tplBacklinkSep

   # Text des Zurueck Buttons
   returnText = config.returnText

   returnPath = ''

   # URL auf HOME, wird zum
   # erzeugen des URL mit Path verwendet
   # meist 'start.py'
   #
   homeurl=None

   # aktueller Inhalt des CGI Parameters path
   # wird von main.py gesetzt
   path=None

   # Menueintraege
   # HINT:
   #   Wird von der Klasse menu
   #   im Verzeichnis conf bei der Initialisierung gesetzt
   #
   entries = []
   addentries = []

   #
   # Konstante fuer URL Kennung in Controller
   #
   controllerIsUrl = '@url:'

   error = ''

   def getEntry(self,path,dieifnotfound=True):
      '''Gibt ein Entry referenziert auf path zurueck
         Wenn "dieifnotfound" gesetzt ist
            wirft Exception wenn nicht auffindbar
         sonst
            wird None zurueckgegeben
         '''
      # durchlaufen der Menueeintraege
      #
      for entry in self.entries:
         # Wenn Eintrag gefunden, wird
         # das Dictionary zurueckgegeben
         if entry['path'] == path:
            return entry
      # Wurde der Parameter dieifnotfound
      # gesetzt wird, wenn der Eintrag nicht
      # gefunden wurde eine Exception geworfen
      if dieifnotfound:
         return None
         raise Exception("Kann keinen Einrag basierend auf '%(path)s' finden" % {path:path})

      # Wenn nicht gefunden, None zurueckgeben
      return None


   def truncatepath(self,path):
      'Abschneiden des letzen Teils des Pfades'

      # Wenn kein Pfad definiert
      # abbruch
      if path == None:
         return

      # Finde den letzten Pfadtrenner
      pos = path.rfind('/')

      # wurde dieser nicht gefunden,
      # wird ein Leerstring zurueckgeliefert
      if pos == -1:
         return ''

      # ist nur mehr ein Eintrag vorhanden
      # diesen Zurueckgeben
      if pos == 0:
         return '/'

      # Wenn wir bis hierher gekommen sind
      # letzen Eintrag abschneiden und das Ergebnis
      # zurueckliefern
      return path[0:pos]

   def getHtml(self,entry):
      'Liefert das HTML Snippet fuer die Anzeige'

      controller = entry.get('controller')

      if controller == None: controller = ''

      # Spezialbehandlung, wenn der Eintrag ein URL ist
      #
      if controller.startswith(self.controllerIsUrl):
         formatstring = self.tplMenuEntry
         controller = controller.replace(self.controllerIsUrl,'')
         formatstring = formatstring.replace('%(homeurl)s?path=%(entry)s',controller)
         retval = formatstring % {'text':entry.get('text')}
         return retval

      # Path
      myPath = entry['path']

      # Wurde Pfad mit '/' beendet, dieses abschneiden
      if myPath != '/' and myPath.endswith('/'): myPath = myPath.rstrip('/')
      # Behandeln von zusaetzlichen CGI Parametern
      if 'addparam' in entry:
         cntP = 0
         for param in entry['addparam']:
            myPath += "&%s" % param

      # Eintrag fuer Menue zusammenstellen
      retval = self.tplMenuEntry % {'homeurl':self.homeurl,'entry':myPath,'text':entry['text'],'tplMenuBullet':self.config.tplMenuBullet}

      return retval

   def hasEntryRight(self,entry):
      'Liefert True wenn der User das Recht hat den Menueintrag aufzurufen'

      # Rechte des Menueeintrags
      rights = entry.get('rights')
      # Flag
      showIt = False
      # wurden Rechte gesetzt
      if rights != None or rights==[]:
         for menRight in rights:

            if self.authen.hasRight(right=menRight):
               showIt = True
      else:
         # Wenn keine Rechte im Menueintrag
         # auf jeden Fall anzeigen
         showIt = True

      return showIt


   def navigation(self):
      'Gibt das gesamte Menue zurueck'
      retval = ''

      # zusammenstellen Menue
      for entry in self.entries:
         # Wenn kein Texteintrag nicht anzeigen
         if entry.get('text') != None:
            # Letzten Pfadeintrag abschneiden
            truncpath = self.truncatepath(entry['path'])
            # Im aktuellen Pfad
            if truncpath == self.path:
               # Ueberpruefen ob User berechtigt ist
               showIt = self.hasEntryRight(entry)
               # Display Attribute bearbeiten
               if showIt:
                  if 'display' in entry:
                     showIt = entry['display']

               if showIt:
                  retval = retval + self.getHtml(entry)

      # Zusaetzliche Entries werden bearbeited
      for entry in self.addentries:
         showIt = self.hasEntryRight(entry)
         if showIt:
            retval = retval + self.getHtml(entry)


      # Wenn nicht oberste Ebene
      # wird Return Schaltflaeche ausgegeben
      # wenn returnText angegeben.

      if self.path != '/root':
         if self.returnPath == '':
            self.returnPath = self.path

         if self.returnText != None:
            retval = retval + self.getHtml({'path':self.truncatepath(self.returnPath),'text':self.returnText})
      return self.tplMenuContainer % {'entry':retval}

   def backlink(self):
      retval = ''

      path = self.path  #self.truncatepath(path=self.path)

      while (path != '/'):
         entry = self.getEntry(path)
         # Ueberpruefen der Option display [True|False]
         # ist display False wird der Eintrag nicht angezegt
         if entry != None:
            display = True if entry.get('display') == None else entry.get('display')
         else:
            display = False
            
         if not display:
            path = self.truncatepath(path)
            continue
            
         if entry==None:
            text = ''
         else:
            text = entry.get('text')

         if text != None:
            url = self.tplBacklinkEntry % {'root':self.config.homeurl,
                                           'path':path,
                                           'text':text
                                           }

            # Bei aktuellem Pfad keinen Trenner einfuegen
            if path != self.path:
               url += self.tplBacklinkSep
            # Resultat zusammenbauen
            retval = url + retval

         path = self.truncatepath(path)

      # moeglicherweise vorhandener leeren Seperator entfernen
      retval = retval.rstrip(self.tplBacklinkSep)

      return self.tplBacklinkContainer % {'entry':retval}

   def setDisplay(self,path=None,mode=True):
      """
      Setzt den Display Status des Eintrag
      @param   path        Patheintrag
      """

      entry = self.getEntry(path,dieifnotfound=True)
      entry['display'] = mode

   def setParam(self,path=None,param=[]):
      """
      Setze dynamisch zusaetzliche Parameter in Menueeintrag
      @param   path        Patheintrag
      @param   param       Paramter als Liste.
      """

      entry = self.getEntry(path,dieifnotfound=True)
      entry['addparam'] = param

   def getControllerPath(self):
      """
      Liefert eine relativen Pfad auf einen Controller.
      Wird nur der Namen angeben, so wird dieser aus der Pfad Option
      und dem Controllernamen des Menueeintrags gebildet.

      Beginnt der Controller Eintrag mit '/' so wird der Pfad relativ zu WEB-INF gebildet.
      """
      entry = self.getEntry(self.path,dieifnotfound=False)
      if entry == None:
         entry = {}

      if 'controller' in entry:
         sController = entry['controller']
         if sController.startswith('/'):
            sController = sController.lstrip('/')
            auxPath = sController
            #auxPath = os.path.split(auxPath)[0]            
            return auxPath
         else:
            auxPath = self.path
            auxPath = auxPath.replace('/','.')
            return ("mvc%(path)s.%(controllername)s" % {'path':auxPath,'controllername':entry.get('controller')})
      else:
         return None

   def getControllerName(self):
      """
      Behandelt die Verwendung von relativen Pfadangaben im Controller Eintrag

      Liefert den Dateinamen des Controllers ohne ".py"

      HINT:
         Verwendet zur Bildung des Namens os.path

      """
      sControllerPath = self.getControllerPath()
      sControllerPath = sControllerPath.replace('.','/')
      (path,tail) = os.path.split(sControllerPath)
      return tail


   def getController(self):
      '''Liefert eine Controller Objekt
         Es wird angenommen, dass der Controller im Dateisystem
         mit dem Pfad der CGI variable path liegt.

         Desweiteren wird ueberprueft, ob der Benutzer das Recht hat
         diesen Controller aufzurufen.
         '''

      self.error = ''

      entry = self.getEntry(self.path)

      if entry == None:
         entry = {}

      if 'controller' in entry:
         if entry.get('controller') == None:
            return None

         if entry.get('controller').startswith('@url:'):
            return None

         if not self.hasEntryRight(entry):
            return None

         cpath = self.path.replace('/','.')
         # vorlaufender Punkt entfernen
         cpath = cpath.lstrip('.')

         # Prepare controllername
         sControllerPath = self.getControllerPath().replace('/','.')
         sControllerName = self.getControllerName()

         sImport = "from %(from)s import %(import)s as Controller" % {
            'from':sControllerPath,
            'import':sControllerName
            }
         errormsg = None

         try:
            exec (sImport)
         except Exception,e:
            errormsg = '<b>Error: '+str(e)+'</b>'

         if errormsg != None:
            raise(Exception('<br /><span style="color:darkblue;font-size:larger;">'+sImport+'</span><br />kann nicht ausgefuehrt werden.<br />'+errormsg))

         controller = Controller()
         controller.path=self.path
         return controller
      else :
         return None
